﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['da']={"application":"Rich Text Editor","editor":"Rich Text Editor","editorPanel":"Rich Text Editor panel","common":{"editorHelp":"Tryk ALT 0 for hjælp","browseServer":"Gennemse...","url":"URL","protocol":"Protokol","upload":"Upload","uploadSubmit":"Upload","image":"Indsæt billede","form":"Indsæt formular","checkbox":"Indsæt afkrydsningsfelt","radio":"Indsæt alternativknap","textField":"Indsæt tekstfelt","textarea":"Indsæt tekstboks","hiddenField":"Indsæt skjult felt","button":"Indsæt knap","select":"Indsæt liste","imageButton":"Indsæt billedknap","notSet":"<intet valgt>","id":"Id","name":"Navn","langDir":"Tekstretning","langDirLtr":"Fra venstre mod højre (LTR)","langDirRtl":"Fra højre mod venstre (RTL)","langCode":"Sprogkode","longDescr":"Udvidet beskrivelse","cssClass":"Typografiark (CSS)","advisoryTitle":"Titel","cssStyle":"Typografi (CSS)","ok":"OK","cancel":"Annullér","close":"Luk","preview":"Forhåndsvisning","resize":"Træk for at skalere","generalTab":"Generelt","advancedTab":"Avanceret","validateNumberFailed":"Værdien er ikke et tal.","confirmNewPage":"Alt indhold, der ikke er blevet gemt, vil gå tabt. Er du sikker på, at du vil indlæse en ny side?","confirmCancel":"Nogle af indstillingerne er blevet ændret. Er du sikker på, at du vil lukke vinduet?","options":"Vis muligheder","target":"Mål","targetNew":"Nyt vindue (_blank)","targetTop":"Øverste vindue (_top)","targetSelf":"Samme vindue (_self)","targetParent":"Samme vindue (_parent)","langDirLTR":"Venstre til højre (LTR)","langDirRTL":"Højre til venstre (RTL)","styles":"Style","cssClasses":"Stylesheetklasser","width":"Bredde","height":"Højde","align":"Justering","left":"Venstre","right":"Højre","center":"Center","justify":"Lige margener","alignLeft":"Venstrestillet","alignRight":"Højrestillet","alignCenter":"Centreret","alignTop":"Øverst","alignMiddle":"Centreret","alignBottom":"Nederst","alignNone":"Ingen","invalidValue":"Ugyldig værdi.","invalidHeight":"Højde skal være et tal.","invalidWidth":"Bredde skal være et tal.","invalidLength":"Værdien angivet for feltet \"%1\" skal være et positivt heltal med eller uden en gyldig måleenhed (%2).","invalidCssLength":"Værdien specificeret for \"%1\" feltet skal være et positivt nummer med eller uden en CSS måleenhed  (px, %, in, cm, mm, em, ex, pt, eller pc).","invalidHtmlLength":"Værdien specificeret for \"%1\" feltet skal være et positivt nummer med eller uden en CSS måleenhed  (px eller %).","invalidInlineStyle":"Værdien specificeret for inline style skal indeholde en eller flere elementer med et format som \"name:value\", separeret af semikoloner","cssLengthTooltip":"Indsæt en numerisk værdi i pixel eller nummer med en gyldig CSS værdi (px, %, in, cm, mm, em, ex, pt, eller pc).","unavailable":"%1<span class=\"cke_accessibility\">, ikke tilgængelig</span>","keyboard":{"8":"Backspace","13":"Retur","16":"Shift","17":"Ctrl","18":"Alt","32":"Mellemrum","35":"Slut","36":"Hjem","46":"Slet","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Kommando"},"keyboardShortcut":"Tastatur genvej","optionDefault":"Standard"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Alle rettigheder forbeholdes.","dlgTitle":"Om CKEditor 4","moreInfo":"For informationer omkring licens, se venligst vores hjemmeside (på engelsk):"},"basicstyles":{"bold":"Fed","italic":"Kursiv","strike":"Gennemstreget","subscript":"Sænket skrift","superscript":"Hævet skrift","underline":"Understreget"},"bidi":{"ltr":"Tekstretning fra venstre til højre","rtl":"Tekstretning fra højre til venstre"},"blockquote":{"toolbar":"Blokcitat"},"notification":{"closed":"Notifikation lukket."},"toolbar":{"toolbarCollapse":"Sammenklap værktøjslinje","toolbarExpand":"Udvid værktøjslinje","toolbarGroups":{"document":"Dokument","clipboard":"Udklipsholder/Fortryd","editing":"Redigering","forms":"Formularer","basicstyles":"Basis styles","paragraph":"Paragraf","links":"Links","insert":"Indsæt","styles":"Typografier","colors":"Farver","tools":"Værktøjer"},"toolbars":"Editors værktøjslinjer"},"clipboard":{"copy":"Kopiér","copyError":"Din browsers sikkerhedsindstillinger tillader ikke editoren at få automatisk adgang til udklipsholderen. Brug i stedet tastaturet til at kopiere teksten (Ctrl/Cmd+C).","cut":"Klip","cutError":"Din browsers sikkerhedsindstillinger tillader ikke editoren at få automatisk adgang til udklipsholderen. Brug i stedet tastaturet til at klippe teksten (Ctrl/Cmd+X).","paste":"Indsæt","pasteNotification":"Tryk %1 for at sætte ind. Din browser understøtter ikke indsættelse med værktøjslinje knappen eller kontekst menuen.","pasteArea":"Indsættelses område","pasteMsg":"Indsæt dit indhold i området nedenfor og tryk OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automatisk","bgColorTitle":"Baggrundsfarve","colors":{"000":"Sort","800000":"Mørkerød","8B4513":"Mørk orange","2F4F4F":"Mørk skifer grå","008080":"Turkis","000080":"Marine","4B0082":"Indigo","696969":"Mørkegrå","B22222":"Scarlet / Rød","A52A2A":"Brun","DAA520":"Guld","006400":"Mørkegrøn","40E0D0":"Turkis","0000CD":"Mellemblå","800080":"Lilla","808080":"Grå","F00":"Rød","FF8C00":"Mørk orange","FFD700":"Guld","008000":"Grøn","0FF":"Cyan","00F":"Blå","EE82EE":"Violet","A9A9A9":"Matgrå","FFA07A":"Laksefarve","FFA500":"Orange","FFFF00":"Gul","00FF00":"Lime","AFEEEE":"Mat turkis","ADD8E6":"Lyseblå","DDA0DD":"Mørkerød","D3D3D3":"Lysegrå","FFF0F5":"Lavendelrød","FAEBD7":"Antikhvid","FFFFE0":"Lysegul","F0FFF0":"Gul / Beige","F0FFFF":"Himmeblå","F0F8FF":"Alice blue","E6E6FA":"Lavendel","FFF":"Hvid","1ABC9C":"Stærk cyan","2ECC71":"Smaragd","3498DB":"Klar blå","9B59B6":"Ametyst","4E5F70":"Glålig blå","F1C40F":"Klar gul","16A085":"Mørk cyan","27AE60":"Mørk smaragd","2980B9":"Stærk blå","8E44AD":"Mørk violet","2C3E50":"Mat blå","F39C12":"Orange","E67E22":"Gulerod","E74C3C":"Bleg rød","ECF0F1":"Klar sølv","95A5A6":"Lys grålig cyan","DDD":"Lys grå","D35400":"Græskar","C0392B":"Stærk rød","BDC3C7":"Sølv","7F8C8D":"Glålig cyan","999":"Mørk grå"},"more":"Flere farver...","panelTitle":"Farver","textColorTitle":"Tekstfarve"},"colordialog":{"clear":"Nulstil","highlight":"Markér","options":"Farvemuligheder","selected":"Valgt farve","title":"Vælg farve"},"templates":{"button":"Skabeloner","emptyListMsg":"(Der er ikke defineret nogen skabelon)","insertOption":"Erstat det faktiske indhold","options":"Skabelon muligheder","selectPromptMsg":"Vælg den skabelon, som skal åbnes i editoren (nuværende indhold vil blive overskrevet):","title":"Indholdsskabeloner"},"contextmenu":{"options":"Muligheder for hjælpemenu"},"copyformatting":{"label":"Kopiér formatering","notification":{"copied":"Formatering kopieret","applied":"Formatering anvendt","canceled":"Formatering annulleret","failed":"Formatering fejlede. Du kan ikke anvende stile uden at kopiere dem først."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Vejledende titel","cssClassInputLabel":"Typografiark","edit":"Rediger Div","inlineStyleInputLabel":"Inline Style","langDirLTRLabel":"Venstre til højre (LTR)","langDirLabel":"Sprogretning","langDirRTLLabel":"Højre til venstre (RTL)","languageCodeInputLabel":" Sprogkode","remove":"Slet Div","styleSelectLabel":"Style","title":"Opret Div Container","toolbar":"Opret Div Container"},"elementspath":{"eleLabel":"Sti på element","eleTitle":"%1 element"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Der skete en fejl ved indlæsningen af filen.","networkError":"Der skete en netværks fejl under uploadingen.","httpError404":"Der skete en HTTP fejl under uploadingen (404: File not found).","httpError403":"Der skete en HTTP fejl under uploadingen (403: Forbidden).","httpError":"Der skete en HTTP fejl under uploadingen (error status: %1).","noUrlError":"Upload URL er ikke defineret.","responseError":"Ikke korrekt server svar."},"find":{"find":"Søg","findOptions":"Find muligheder","findWhat":"Søg efter:","matchCase":"Forskel på store og små bogstaver","matchCyclic":"Match cyklisk","matchWord":"Kun hele ord","notFoundMsg":"Søgeteksten blev ikke fundet","replace":"Erstat","replaceAll":"Erstat alle","replaceSuccessMsg":"%1 forekomst(er) erstattet.","replaceWith":"Erstat med:","title":"Søg og erstat"},"font":{"fontSize":{"label":"Skriftstørrelse","voiceLabel":"Skriftstørrelse","panelTitle":"Skriftstørrelse"},"label":"Skrifttype","panelTitle":"Skrifttype","voiceLabel":"Skrifttype"},"fakeobjects":{"anchor":"Anker","hiddenfield":"Skjult felt","iframe":"Iframe","unknown":"Ukendt objekt"},"forms":{"button":{"title":"Egenskaber for knap","text":"Tekst","type":"Type","typeBtn":"Knap","typeSbm":"Send","typeRst":"Nulstil"},"checkboxAndRadio":{"checkboxTitle":"Egenskaber for afkrydsningsfelt","radioTitle":"Egenskaber for alternativknap","value":"Værdi","selected":"Valgt","required":"Påkrævet"},"form":{"title":"Egenskaber for formular","menu":"Egenskaber for formular","action":"Handling","method":"Metode","encoding":"Kodning (encoding)"},"hidden":{"title":"Egenskaber for skjult felt","name":"Navn","value":"Værdi"},"select":{"title":"Egenskaber for liste","selectInfo":"Generelt","opAvail":"Valgmuligheder","value":"Værdi","size":"Størrelse","lines":"Linjer","chkMulti":"Tillad flere valg","required":"Påkrævet","opText":"Tekst","opValue":"Værdi","btnAdd":"Tilføj","btnModify":"Redigér","btnUp":"Op","btnDown":"Ned","btnSetValue":"Sæt som valgt","btnDelete":"Slet"},"textarea":{"title":"Egenskaber for tekstboks","cols":"Kolonner","rows":"Rækker"},"textfield":{"title":"Egenskaber for tekstfelt","name":"Navn","value":"Værdi","charWidth":"Bredde (tegn)","maxChars":"Max. antal tegn","required":"Påkrævet","type":"Type","typeText":"Tekst","typePass":"Adgangskode","typeEmail":"E-mail","typeSearch":"Søg","typeTel":"Telefonnummer","typeUrl":"URL"}},"format":{"label":"Formatering","panelTitle":"Formatering","tag_address":"Adresse","tag_div":"Normal (DIV)","tag_h1":"Overskrift 1","tag_h2":"Overskrift 2","tag_h3":"Overskrift 3","tag_h4":"Overskrift 4","tag_h5":"Overskrift 5","tag_h6":"Overskrift 6","tag_p":"Normal","tag_pre":"Formateret"},"horizontalrule":{"toolbar":"Indsæt vandret streg"},"iframe":{"border":"Vis kant på rammen","noUrl":"Venligst indsæt URL på iframen","scrolling":"Aktiver scrollbars","title":"Iframe egenskaber","toolbar":"Iframe","tabindex":"Remove from tabindex"},"image":{"alt":"Alternativ tekst","border":"Ramme","btnUpload":"Upload fil til serveren","button2Img":"Vil du lave billedknappen om til et almindeligt billede?","hSpace":"Vandret margen","img2Button":"Vil du lave billedet om til en billedknap?","infoTab":"Generelt","linkTab":"Hyperlink","lockRatio":"Lås størrelsesforhold","menu":"Egenskaber for billede","resetSize":"Nulstil størrelse","title":"Egenskaber for billede","titleButton":"Egenskaber for billedknap","upload":"Upload","urlMissing":"Kilde på billed-URL mangler","vSpace":"Lodret margen","validateBorder":"Kant skal være et helt nummer.","validateHSpace":"HSpace skal være et helt nummer.","validateVSpace":"VSpace skal være et helt nummer."},"indent":{"indent":"Forøg indrykning","outdent":"Formindsk indrykning"},"smiley":{"options":"Smileymuligheder","title":"Indsæt en smiley","toolbar":"Smiley"},"language":{"button":"Vælg sprog","remove":"Fjern sprog"},"link":{"acccessKey":"Genvejstast","advanced":"Avanceret","advisoryContentType":"Indholdstype","advisoryTitle":"Titel","anchor":{"toolbar":"Indsæt/redigér bogmærke","menu":"Egenskaber for bogmærke","title":"Egenskaber for bogmærke","name":"Bogmærkenavn","errorName":"Indtast bogmærkenavn","errorWhitespace":"Anchor name cannot contain space characters","remove":"Fjern bogmærke"},"anchorId":"Efter element-Id","anchorName":"Efter ankernavn","charset":"Tegnsæt","cssClasses":"Typografiark","download":"Tving Download","displayText":"Vis tekst","emailAddress":"E-mailadresse","emailBody":"Besked","emailSubject":"Emne","id":"Id","info":"Generelt","langCode":"Tekstretning","langDir":"Tekstretning","langDirLTR":"Fra venstre mod højre (LTR)","langDirRTL":"Fra højre mod venstre (RTL)","menu":"Redigér hyperlink","name":"Navn","noAnchors":"(Ingen bogmærker i dokumentet)","noEmail":"Indtast e-mailadresse!","noUrl":"Indtast hyperlink-URL!","noTel":"Indtast venligst et telefonnummer","other":"<anden>","phoneNumber":"Telefonnummer","popupDependent":"Koblet/dependent (Netscape)","popupFeatures":"Egenskaber for popup","popupFullScreen":"Fuld skærm (IE)","popupLeft":"Position fra venstre","popupLocationBar":"Adresselinje","popupMenuBar":"Menulinje","popupResizable":"Justérbar","popupScrollBars":"Scrollbar","popupStatusBar":"Statuslinje","popupToolbar":"Værktøjslinje","popupTop":"Position fra toppen","rel":"Relation","selectAnchor":"Vælg et anker","styles":"Typografi","tabIndex":"Tabulatorindeks","target":"Mål","targetFrame":"<ramme>","targetFrameName":"Destinationsvinduets navn","targetPopup":"<popup vindue>","targetPopupName":"Popupvinduets navn","title":"Egenskaber for hyperlink","toAnchor":"Bogmærke på denne side","toEmail":"E-mail","toUrl":"URL","toPhone":"Telefon","toolbar":"Indsæt/redigér hyperlink","type":"Type","unlink":"Fjern hyperlink","upload":"Upload"},"list":{"bulletedlist":"Punktopstilling","numberedlist":"Talopstilling"},"liststyle":{"bulletedTitle":"Værdier for cirkelpunktopstilling","circle":"Cirkel","decimal":"Decimal (1, 2, 3, osv.)","disc":"Værdier for diskpunktopstilling","lowerAlpha":"Små alfabet (a, b, c, d, e, etc.)","lowerRoman":"Små romerske (i, ii, iii, iv, v, etc.)","none":"Ingen","notset":"<ikke defineret>","numberedTitle":"Egenskaber for nummereret liste","square":"Firkant","start":"Start","type":"Type","upperAlpha":"Store alfabet (A, B, C, D, E, etc.)","upperRoman":"Store romerske (I, II, III, IV, V, etc.)","validateStartNumber":"Den nummererede liste skal starte med et rundt nummer"},"magicline":{"title":"Indsæt afsnit"},"maximize":{"maximize":"Maksimér","minimize":"Minimér"},"newpage":{"toolbar":"Ny side"},"pagebreak":{"alt":"Sideskift","toolbar":"Indsæt sideskift"},"pastetext":{"button":"Indsæt som ikke-formateret tekst","pasteNotification":"Klik %1 for at indsætte. Din browser understøtter ikke indsæt med tastatur eller kontekstmenu-valg.","title":"Indsæt som ikke-formateret tekst"},"pastefromword":{"confirmCleanup":"Den tekst du forsøger at indsætte ser ud til at komme fra Word. Vil du rense teksten før den indsættes?","error":"Det var ikke muligt at fjerne formatteringen på den indsatte tekst grundet en intern fejl","title":"Indsæt fra Word","toolbar":"Indsæt fra Word"},"preview":{"preview":"Vis eksempel"},"print":{"toolbar":"Udskriv"},"removeformat":{"toolbar":"Fjern formatering"},"save":{"toolbar":"Gem"},"selectall":{"toolbar":"Vælg alt"},"showblocks":{"toolbar":"Vis afsnitsmærker"},"sourcearea":{"toolbar":"Kilde"},"specialchar":{"options":"Muligheder for specielle karakterer","title":"Vælg specielle karakterer","toolbar":"Indsæt specielle karakterer"},"scayt":{"btn_about":"Om SCAYT","btn_dictionaries":"Ordbøger","btn_disable":"Deaktivér SCAYT","btn_enable":"Aktivér SCAYT","btn_langs":"Sprog","btn_options":"Indstillinger","text_title":"Stavekontrol mens du skriver"},"stylescombo":{"label":"Typografi","panelTitle":"Formatering på stylesheet","panelTitle1":"Blok typografi","panelTitle2":"Inline typografi","panelTitle3":"Objekt typografi"},"table":{"border":"Rammebredde","caption":"Titel","cell":{"menu":"Celle","insertBefore":"Indsæt celle før","insertAfter":"Indsæt celle efter","deleteCell":"Slet celle","merge":"Flet celler","mergeRight":"Flet til højre","mergeDown":"Flet nedad","splitHorizontal":"Del celle vandret","splitVertical":"Del celle lodret","title":"Celleegenskaber","cellType":"Celletype","rowSpan":"Række span (rows span)","colSpan":"Kolonne span (columns span)","wordWrap":"Tekstombrydning","hAlign":"Vandret justering","vAlign":"Lodret justering","alignBaseline":"Grundlinje","bgColor":"Baggrundsfarve","borderColor":"Rammefarve","data":"Data","header":"Hoved","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Ja","no":"Nej","invalidWidth":"Cellebredde skal være et tal.","invalidHeight":"Cellehøjde skal være et tal.","invalidRowSpan":"Række span skal være et heltal.","invalidColSpan":"Kolonne span skal være et heltal.","chooseColor":"Vælg"},"cellPad":"Cellemargen","cellSpace":"Celleafstand","column":{"menu":"Kolonne","insertBefore":"Indsæt kolonne før","insertAfter":"Indsæt kolonne efter","deleteColumn":"Slet kolonne"},"columns":"Kolonner","deleteTable":"Slet tabel","headers":"Hoved","headersBoth":"Begge","headersColumn":"Første kolonne","headersNone":"Ingen","headersRow":"Første række","heightUnit":"højde enhed","invalidBorder":"Rammetykkelse skal være et tal.","invalidCellPadding":"Cellemargen skal være et tal.","invalidCellSpacing":"Celleafstand skal være et tal.","invalidCols":"Antallet af kolonner skal være større end 0.","invalidHeight":"Tabelhøjde skal være et tal.","invalidRows":"Antallet af rækker skal være større end 0.","invalidWidth":"Tabelbredde skal være et tal.","menu":"Egenskaber for tabel","row":{"menu":"Række","insertBefore":"Indsæt række før","insertAfter":"Indsæt række efter","deleteRow":"Slet række"},"rows":"Rækker","summary":"Resumé","title":"Egenskaber for tabel","toolbar":"Tabel","widthPc":"procent","widthPx":"pixels","widthUnit":"Bredde på enhed"},"undo":{"redo":"Annullér fortryd","undo":"Fortryd"},"widget":{"move":"Klik og træk for at flytte","label":"%1 widget"},"uploadwidget":{"abort":"Upload er afbrudt af bruger.","doneOne":"Filen er uploadet.","doneMany":"Du har uploadet %1 filer.","uploadOne":"Uploader fil ({percentage}%)...","uploadMany":"Uploader filer, {current} af {max} er uploadet ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Kilde","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Søg emojier...","searchLabel":"Indtastningsfelt ansvarligt for udsøgning og filtrering af emojier i panelet.","navigationLabel":"Grupperer navigation for emojisektioner.","title":"Emoji-liste","groups":{"people":"Mennesker","nature":"Natur og dyr","food":"Mad og drikkelse","travel":"Rejser og steder","activities":"Aktiviteter","objects":"Objekter","symbols":"Symboler","flags":"Flag"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Kilde","title":"Kilde"}};